/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fanslab;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.fanslab.BlockFanSlab;
import com.lothrazar.cyclic.net.PacketPlayerFalldamage;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TileFanSlab
extends TileBlockEntityCyclic {
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 64;
    public static final int MIN_SPEED = 1;
    public static final int MAX_SPEED = 20;
    private int range = 5;
    private int speed = 5;

    public TileFanSlab(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.FANSLAB.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileFanSlab e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileFanSlab e) {
        e.tick();
    }

    public void tick() {
        boolean powered = this.isPowered();
        boolean previous = (Boolean)this.m_58900_().m_61143_((Property)BlockFanSlab.POWERED);
        if (previous != powered) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockFanSlab.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
        if (powered) {
            this.pushEntities();
        }
    }

    public int getRange() {
        return this.range;
    }

    private float getSpeedCalc() {
        return (float)this.speed / 39.0f;
    }

    private int getCurrentRange() {
        Direction facing = this.getCurrentFacing();
        for (int i = 1; i <= this.getRange(); ++i) {
            BlockPos tester = this.m_58899_().m_5484_(facing, i);
            if (this.canBlowThrough(tester)) continue;
            return i;
        }
        return this.getRange();
    }

    private boolean canBlowThrough(BlockPos tester) {
        return !this.f_58857_.m_8055_(tester).m_60815_();
    }

    public List<BlockPos> getShape() {
        return ShapeUtil.line(this.m_58899_(), this.getCurrentFacing(), this.getCurrentRange());
    }

    @Override
    public Direction getCurrentFacing() {
        switch ((AttachFace)this.m_58900_().m_61143_(BlockFanSlab.FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)this.m_58900_().m_61143_((Property)BlockFanSlab.HORIZONTAL_FACING);
    }

    private int pushEntities() {
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return 0;
        }
        BlockPos start = shape.get(0);
        BlockPos end = shape.get(shape.size() - 1);
        switch (this.getCurrentFacing().m_122434_()) {
            case X: {
                end = end.m_142082_(0, 0, 1);
                end = end.m_142082_(0, 1, 0);
                break;
            }
            case Z: {
                end = end.m_142082_(1, 0, 0);
                end = end.m_142082_(0, 1, 0);
                break;
            }
            case Y: {
                start = start.m_142082_(1, 0, 0);
                end = end.m_142082_(0, 0, 1);
            }
        }
        Direction face = this.getCurrentFacing();
        switch (face) {
            case NORTH: {
                start = start.m_142128_();
                start = start.m_142128_();
                break;
            }
            case SOUTH: {
                start = start.m_142127_();
                end = end.m_142128_();
                break;
            }
            case EAST: {
                start = start.m_142125_();
                end = end.m_142126_();
                break;
            }
            case WEST: {
                start = start.m_142126_();
                start = start.m_142126_();
                break;
            }
            case DOWN: {
                break;
            }
        }
        AABB region = new AABB(start, end);
        List entitiesFound = this.m_58904_().m_45976_(Entity.class, region);
        int moved = 0;
        boolean doPush = true;
        int direction = 1;
        float speed = this.getSpeedCalc();
        for (Entity entity : entitiesFound) {
            if (entity instanceof Player && ((Player)entity).m_6047_()) continue;
            ++moved;
            double newx = entity.m_20184_().m_7096_();
            double newy = entity.m_20184_().m_7098_();
            double newz = entity.m_20184_().m_7094_();
            switch (face) {
                case NORTH: {
                    direction = -1;
                    newz += (double)((float)direction * speed);
                    break;
                }
                case SOUTH: {
                    direction = 1;
                    newz += (double)((float)direction * speed);
                    break;
                }
                case EAST: {
                    direction = 1;
                    newx += (double)((float)direction * speed);
                    break;
                }
                case WEST: {
                    direction = -1;
                    newx += (double)((float)direction * speed);
                    break;
                }
                case DOWN: {
                    direction = -1;
                    newy += (double)((float)direction * speed);
                    break;
                }
                case UP: {
                    direction = 1;
                    newy += (double)((float)direction * speed);
                }
            }
            entity.m_20334_(newx, newy, newz);
            if (!this.f_58857_.f_46443_ || entity.f_19797_ % 22 != 0 || !(entity instanceof Player)) continue;
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketPlayerFalldamage());
        }
        return moved;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.speed = tag.m_128451_("speed");
        this.range = tag.m_128451_("range");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("speed", this.speed);
        tag.m_128405_("range", this.range);
        super.m_183515_(tag);
    }

    @Override
    public int getField(int f) {
        switch (Fields.values()[f]) {
            case RANGE: {
                return this.range;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SPEED: {
                return this.speed;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        Fields f = Fields.values()[field];
        switch (f) {
            case RANGE: {
                this.range = value;
                if (this.range < 1) {
                    this.range = 1;
                }
                if (this.range <= 64) break;
                this.range = 64;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case SPEED: {
                this.speed = value;
                if (this.speed < 1) {
                    this.speed = 1;
                }
                if (this.speed <= 20) break;
                this.speed = 20;
            }
        }
    }

    static enum Fields {
        REDSTONE,
        RANGE,
        SPEED;

    }
}

